#include <SPI.h>
#include <MFRC522.h>

// Pin-Definitionen
const int piezoPin = 8;  // Pin für den Piezo-Lautsprecher
const int buttonPin = 7; // Pin für den Taster

#define RST_PIN 9   // Reset-Pin für MFRC522
#define SS_PIN 10   // Slave Select-Pin für MFRC522

MFRC522 rfid(SS_PIN, RST_PIN);

// Liste von RFID-Karten-IDs wird zur Laufzeit eingelesen
String rfidTags[10];


int LED1 = 2;
int LED2 = 3; 
int LED3 = 4; 
int LED4 = 5; 
int LEDRot = 6; 


void setup() {
  // LED pins deklarieren
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(LED3, OUTPUT);
  pinMode(LED4, OUTPUT);
  pinMode(LEDRot, OUTPUT);

  // Setze den Piezo-Pin als Ausgang
  pinMode(piezoPin, OUTPUT);

  // Setze den Button-Pin als Eingang mit internem Pull-Up-Widerstand
  pinMode(buttonPin, INPUT_PULLUP);
  
  Serial.begin(9600);
  SPI.begin();
  rfid.PCD_Init();
  Serial.println("RFID Reader bereit. Halte eine Karte an den Sensor, um IDs zu speichern.");

  // IDs der Karten einlesen
  for (int i = 0; i < 10; i++) {
    Serial.print("Bitte Karte ");
    Serial.print(i + 1);
    Serial.println(" scannen.");

    while (!rfid.PICC_IsNewCardPresent() || !rfid.PICC_ReadCardSerial()) {
      // Warten, bis eine Karte gelesen wird
    }

    // RFID-Karten-ID auslesen und in einen String umwandeln
    String cardID = "";
    for (byte j = 0; j < rfid.uid.size; j++) {
      cardID += String(rfid.uid.uidByte[j], HEX);
    }
    cardID.toUpperCase();

    rfidTags[i] = cardID;
    Serial.print("Karte ");
    Serial.print(i + 1);
    Serial.print(" gespeichert: ");
    Serial.println(cardID);

    // Karte loslassen
    rfid.PICC_HaltA();
  }

  Serial.println("Alle Karten gespeichert. Sie können jetzt Funktionen testen.");

}

void Morsecode() {
  int buttonState = digitalRead(buttonPin);

  // 1 ------------------------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  //Zeichen für neue Zahl ---------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(100);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);
  //-----------------------------------------------------------------------------------

  // 9 ---------------------------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);


  //Zeichen für neue Zahl ---------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(100);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);
  //-----------------------------------------------------------------------------------

  // 0 --------------------------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(1500);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  //Zeichen für neue Zahl ---------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(100);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);
  //-----------------------------------------------------------------------------------

  // 5 --------------------------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  tone(piezoPin, 1000, 1000); // Spiele einen Ton mit 1000 Hz für 1000 ms
  delay(300);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);

  //Zeichen für neue Zahl ---------------------------------------------------------------
  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(100);

  tone(piezoPin, 1000, 1000); // Spiele einen weiteren Ton mit 1000 Hz für 1000 ms
  delay(100);
  noTone(piezoPin);          // Stoppe den Ton
  delay(1000);
  //-------------------------------------------------------------------------------------
}

void loop() {
  int buttonState = digitalRead(buttonPin);

  if (buttonState == LOW) {
    Serial.print("hallo");
    Morsecode();
  }




  // Prüfen, ob eine Karte gelesen werden kann
  if (!rfid.PICC_IsNewCardPresent() || !rfid.PICC_ReadCardSerial()) {
    return;
  }

  // RFID-Karten-ID auslesen und in einen String umwandeln
  String cardID = "";
  for (byte i = 0; i < rfid.uid.size; i++) {
    cardID += String(rfid.uid.uidByte[i], HEX);
  }
  cardID.toUpperCase();

  Serial.println("Karte erkannt: " + cardID);

  // Karte in der Liste suchen und zugehörige Aktion ausführen
  int action = -1;
  for (int i = 0; i < 10; i++) {
    if (cardID == rfidTags[i]) {
      action = i;
      break;
    }
  }


  // Aktionen mit einer switch-case-Funktion ausführen
  switch (action) {
    case 0:
      Serial.println("Aktion 0: LED einschalten");


      digitalWrite(LED3, HIGH);
      delay(1000);
      digitalWrite(LED3, LOW);
      break;
    case 1:
      Serial.println("Aktion 1: Motor starten");

      digitalWrite(LED1, HIGH);
      delay(1000);
      digitalWrite(LED1, LOW);

      break;
    case 2:
      Serial.println("Aktion 2: Alarm aktivieren");

      digitalWrite(LEDRot, HIGH);
      delay(1000);
      digitalWrite(LEDRot, LOW);

      break;
    case 3:
      Serial.println("Aktion 3: Tür öffnen");

      digitalWrite(LEDRot, HIGH);
      delay(1000);
      digitalWrite(LEDRot, LOW);

      break;
    case 4:
      Serial.println("Aktion 4: Nachricht senden");

      digitalWrite(LEDRot, HIGH);
      delay(1000);
      digitalWrite(LEDRot, LOW);


      break;
    case 5:
      Serial.println("Aktion 5: Daten loggen");

      digitalWrite(LED4, HIGH);
      delay(1000);
      digitalWrite(LED4, LOW);

      break;
    case 6:
      Serial.println("Aktion 6: Sensor auslesen");

      digitalWrite(LEDRot, HIGH);
      delay(1000);
      digitalWrite(LEDRot, LOW);

      break;
    case 7:
      Serial.println("Aktion 7: Display aktualisieren");

      digitalWrite(LEDRot, HIGH);
      delay(1000);
      digitalWrite(LEDRot, LOW);

      break;
    case 8:
      Serial.println("Aktion 8: Systemstatus prüfen");

      digitalWrite(LEDRot, HIGH);
      delay(1000);
      digitalWrite(LEDRot, LOW);

      break;
    case 9:
      Serial.println("Aktion 9: Shutdown einleiten");

      digitalWrite(LED2, HIGH);
      delay(1000);
      digitalWrite(LED2, LOW);


      break;
    default:
      Serial.println("Unbekannte Karte");
      break;
  }    

  // Karte loslassen
  rfid.PICC_HaltA();

}
